# Расширение 2
Ферма снова выросла! Клетки больше не расположены аккуратным рядом, поэтому тебе нужно найти способ облететь квадратное поле.

Цикл `while` тут не поможет, пока ты не разблокируешь датчики и операторы.
Пришло время познакомиться с циклом `for`.

Ты можешь прочитать все о цикле `for` на странице [Цикл `for`](docs/scripting/for.md). Пока он понадобится только для того, чтобы повторить код определенное количество раз.

`#сделать n сальто
for i in range(5):
	do_a_flip()`

`range(n)` создает диапазон чисел от `0` до `n-1`, в котором `n` элементов. Цикл `for` выполняет свое тело один раз для каждого элемента в последовательности. В этом примере команда `do_a_flip()` будет вызвана `5` раз.

Тебе также доступна функция `get_world_size()`. Она возвращает длину стороны фермы. Таким образом, ты можешь писать код, который не перестанет работать при следующем улучшении расширения.

`for i in range(get_world_size()):
	harvest()
	move(North)`

В этом примере дрон собирает урожай с одного столбца на ферме любого размера.

Если ты не понимаешь, как перемещать дрон по ферме, посмотри подсказку ниже.
<spoiler=показать подсказку>Конечно, есть несколько способов перемещения по ферме.
Однако нам нужен способ облетать ее систематически, чтобы код не перестал работать при следующем улучшении фермы.
Систематический способ добраться до любого места на ферме — это вечно повторять следующие два шага:

1. Перемещаться в направлении `North` до тех пор, пока не вернешься к началу.
2. Перемещаться в направлении `East`.

Для воплощения этой идеи в коде может подойти такая запись: `for i in range(get_world_size()):`.
</spoiler>
<spoiler=показать возможное решение><spoiler=show possible solution> Базовый облет может выглядеть так:

`for i in range(get_world_size()):
	for j in range(get_world_size()):
		#делать сальто на каждой клетке
		do_a_flip()
		move(North)
	move(East)`
</spoiler>